# How to use dns api

## 1. Use CloudFlare domain api to automatically issue cert

For now, we support clourflare integeration.

First you need to login to your clourflare account to get your api key.

```
export CF_Key="sdfsdfsdfljlbjkljlkjsdfoiwje"

export CF_Email="xxxx@sss.com"

```

Ok, let's issue cert now:
```
acme.sh   --issue   --dns dns_cf   -d example.com  -d www.example.com
```

The `CF_Key` and `CF_Email`  will be saved in `~/.acme.sh/account.conf`, when next time you use cloudflare api, it will reuse this key.



## 2. Use Dnspod.cn domain api to automatically issue cert

For now, we support dnspod.cn integeration.

First you need to login to your dnspod.cn account to get your api key and key id.

```
export DP_Id="1234"

export DP_Key="sADDsdasdgdsf"

```

Ok, let's issue cert now:
```
acme.sh   --issue   --dns dns_dp   -d example.com  -d www.example.com
```

The `DP_Id` and `DP_Key`  will be saved in `~/.acme.sh/account.conf`, when next time you use dnspod.cn api, it will reuse this key.


## 3. Use Cloudxns.com domain api to automatically issue cert

For now, we support Cloudxns.com integeration.

First you need to login to your Cloudxns.com account to get your api key and key secret.

```
export CX_Key="1234"

export CX_Secret="sADDsdasdgdsf"

```

Ok, let's issue cert now:
```
acme.sh   --issue   --dns dns_cx   -d example.com  -d www.example.com
```

The `CX_Key` and `CX_Secret`  will be saved in `~/.acme.sh/account.conf`, when next time you use Cloudxns.com api, it will reuse this key.


## 4. Use Godaddy.com domain api to automatically issue cert

We support Godaddy integration.

First you need to login to your Godaddy account to get your api key and api secret.

https://developer.godaddy.com/keys/

Please Create a Production key, instead of a Test key.


```
export GD_Key="sdfsdfsdfljlbjkljlkjsdfoiwje"

export GD_Secret="asdfsdafdsfdsfdsfdsfdsafd"

```

Ok, let's issue cert now:
```
acme.sh   --issue   --dns dns_gd   -d example.com  -d www.example.com
```

The `GD_Key` and `GD_Secret`  will be saved in `~/.acme.sh/account.conf`, when next time you use cloudflare api, it will reuse this key.

## 5. Use PowerDNS embedded api to automatically issue cert

We support PowerDNS embedded API integration.

First you need to enable api and set your api-token in PowerDNS configuration.

https://doc.powerdns.com/md/httpapi/README/

```
export PDNS_Url="http://ns.example.com:8081"
export PDNS_ServerId="localhost"
export PDNS_Token="0123456789ABCDEF"
export PDNS_Ttl=60

```

Ok, let's issue cert now:
```
acme.sh   --issue   --dns dns_pdns   -d example.com  -d www.example.com
```

The `PDNS_Url`, `PDNS_ServerId`, `PDNS_Token` and `PDNS_Ttl` will be saved in `~/.acme.sh/account.conf`.


## 6. Use OVH/kimsufi/soyoustart/runabove API

https://github.com/Neilpang/acme.sh/wiki/How-to-use-OVH-domain-api

## 7. Use nsupdate to automatically issue cert

First, generate a key for updating the zone
```
b=$(dnssec-keygen -a hmac-sha512 -b 512 -n USER -K /tmp foo)
cat > /etc/named/keys/update.key <<EOF
key "update" {
    algorithm hmac-sha512;
    secret "$(awk '/^Key/{print $2}' /tmp/$b.private)";
};
EOF
rm -f /tmp/$b.{private,key}
```

Include this key in your named configuration
```
include "/etc/named/keys/update.key";
```

Next, configure your zone to allow dynamic updates.
Depending on your named version, use either
```
zone "example.com" {
    type master;
    allow-update { key "update"; };
};
```
or
```
zone "example.com" {
    type master;
    update-policy {
        grant update subdomain example.com.;
    };
}
```
Finally, make the dns server and update key available to `acme.sh`
```
export NSUPDATE_SERVER=dns.example.com
export NSUPDATE_KEY=aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa==
```

Ok, let's issue cert now:
```
acme.sh   --issue   --dns dns_nsupdate   -d example.com  -d www.example.com
```

The `NSUPDATE_SERVER` and `NSUPDATE_KEY` settings will be saved in `~/.acme.sh/account.conf`.

## 8. Use LuaDNS domain API

Get your API token at https://api.luadns.com/settings

```
export LUA_Key="sdfsdfsdfljlbjkljlkjsdfoiwje"

export LUA_Email="xxxx@sss.com"

```

To issue a cert:
```
acme.sh   --issue   --dns dns_lua --dnssleep 3  -d example.com  -d www.example.com
```

The `LUA_Key` and `LUA_Email`  will be saved in `~/.acme.sh/account.conf`, and will be reused when needed.

## 9. Use DNSMadeEasy domain API

Get your API credentials at https://cp.dnsmadeeasy.com/account/info

```
export ME_Key="sdfsdfsdfljlbjkljlkjsdfoiwje"

export ME_Secret="qdfqsdfkjdskfj"

```

To issue a cert:
```
acme.sh   --issue   --dns dns_me --dnssleep 3  -d example.com  -d www.example.com
```

The `ME_Key` and `ME_Secret`  will be saved in `~/.acme.sh/account.conf`, and will be reused when needed.

# 10. Use custom api

If your api is not supported yet,  you can write your own dns api.

Let's assume you want to name it 'myapi',

1. Create a bash script named  `~/.acme.sh/dns_myapi.sh`,
2. In the script, you must have a function named `dns_myapi_add()`. Which will be called by acme.sh to add dns records.
3. Then you can use your api to issue cert like:

```
acme.sh  --issue  --dns  dns_myapi  -d example.com  -d www.example.com
```

For more details, please check our sample script: [dns_myapi.sh](dns_myapi.sh)

# 11. Use lexicon dns api

https://github.com/Neilpang/acme.sh/wiki/How-to-use-lexicon-dns-api





