# XPT2046 Module
| Since  | Origin / Contributor  | Maintainer  | Source  |
| :----- | :-------------------- | :---------- | :------ |
| 2017-03-09| [Starofall](https://github.com/nodemcu/nodemcu-firmware/pull/1242)/[Frank Exoo](https://github.com/FrankX0) | [Frank Exoo](https://github.com/FrankX0) | [xpt2046.c](../../app/modules/xpt2046.c)|

XPT2046 is a touch controller used by several cheap displays - often in combination with the ILI9341 display controller.
The module is built based on the libraries of [spapadim](https://github.com/spapadim/XPT2046/) and [PaulStoffregen](https://github.com/PaulStoffregen/XPT2046_Touchscreen).


## xpt2046.init()
Initiates the XPT2046 module to read touch values from the display. It is required to call [`spi.setup()`](spi.md#spisetup) before calling `xpt2046.init` (see example).
As the ucg lib also requires [`spi.setup()`](spi.md#spisetup) to be called before it is important to only call it once in total and to activate `spi.FULLDUPLEX`.
The `clock_div` used in [`spi.setup()`](spi.md#spisetup) should be 16 or higher, as lower values might produces inaccurate results.

#### Syntax
`xpt2046.init(cs_pin, irq_pin, height, width)`

#### Parameters
- `cs_pin` GPIO pin for cs
- `irq_pin` GPIO pin for irq
- `height` display height in pixel
- `width` display width in pixel

#### Returns
`nil`

#### Example
```lua
-- Setup spi with `clock_div` of 16 and spi.FULLDUPLEX
spi.setup(1, spi.MASTER, spi.CPOL_LOW, spi.CPHA_LOW, 8, 16,spi.FULLDUPLEX)
-- SETTING UP DISPLAY (using ucg module)
local disp = ucg.ili9341_18x240x320_hw_spi(8, 4, 0)
disp:begin(0)
-- SETTING UP TOUCH
xpt2046.init(2,1,320,240)
xpt2046.setCalibration(198, 1776, 1762, 273)
```


## xpt2046.setCalibration()
Sets the calibration of the display. Calibration values can be obtained by using [`xpt2046.getRaw()`](#xpt2046getraw) and read the values in the edges.

#### Syntax
`xpt2046.setCalibration(x1, y1, x2, y2)`

#### Parameters
- `x1` raw x value at top left
- `y1` raw y value at top left
- `x2` raw x value at bottom right
- `y2` raw y value at bottom right

#### Returns
`nil`


## xpt2046.isTouched()
Checks if the touch panel is touched.

#### Syntax
`xpt2046.isTouched()`

#### Returns
`true` if the display is touched, else `false`

#### Example
```lua
if(xpt2046.isTouched()) then
	local x, y = xpt2046.getPosition()
	print(x .. "-" .. y)
end
```


## xpt2046.getPosition()
Returns the position the display is touched using the calibration values and given width and height.
Can be used in an interrupt pin callback to return the coordinates when the touch screen is touched.

#### Syntax
`xpt2046.getPosition()`

#### Returns
returns both the x and the y position.

#### Example
```lua
-- Setup spi with `clock_div` of 16 and spi.FULLDUPLEX
spi.setup(1, spi.MASTER, spi.CPOL_LOW, spi.CPHA_LOW, 8, 16,spi.FULLDUPLEX)
-- SETTING UP TOUCH
cs_pin  = 2 -- GPIO4
irq_pin = 3 -- GPIO0
height  = 240
width = 320
xpt2046.init(cs_pin, irq_pin, width, height)
xpt2046.setCalibration(198, 1776, 1762, 273)
gpio.mode(irq_pin,gpio.INT,gpio.PULLUP)
gpio.trig(irq_pin, "down", function()
    print(xpt2046.getPosition())
end)
```


## xpt2046.getPositionAvg()
To create better measurements this function reads the position three times and averages the two positions with the least distance.

#### Syntax
`xpt2046.getPositionAvg()`

#### Returns
returns both the x and the y position.

#### Example
```lua
local x, y = xpt2046.getPositionAvg()
print(x .. "-" .. y)
```


## xpt2046.getRaw()
Reads the raw value from the display. Useful for debugging and custom conversions.

#### Syntax
`xpt2046.getRaw()`

#### Returns
returns both the x and the y position as a raw value.

#### Example
```lua
local rawX, rawY = xpt2046.getRaw()
print(rawX .. "-" .. rawY)
```
