# HDC1000 Module
| Since  | Origin / Contributor  | Maintainer  | Source  |
| :----- | :-------------------- | :---------- | :------ |
| 2015-03-07 | [Francesco Truzzi](https://github.com/ftruzzi) | [Francesco Truzzi](https://github.com/ftruzzi) | [hdc1000.lua](../../lua_modules/hdc1000/HDC1000.lua) |

This Lua module provides access to [HDC1000](https://www.ti.com/lit/ds/symlink/hdc1000.pdf) I²C digital humidity and temperature sensor. It should also work with HDC1008 sensor bout this haven't been tested.

!!! note
	This module requires `i2c` C module built into firmware.

### Require
```lua
HDC1000 = require("HDC1000")
```

### Release
```lua
HDC1000 = nil
package.loaded["HDC1000"] = nil
```

## HDC1000.setup()
Function to setup the HDC1000 sensor.

#### Syntax
`HDC1000.setup(drdyn)`

#### Parameters
- `drdyn`: DRDYn pin number. If set to `false`, this feature will not be used and after each read request a 20ms delay will be added.

#### Returns
`nil`

#### Example
```lua
local sda, scl = 3, 4 -- Pins 3 and 4 will be used
local drdyn = 6 -- Pin 6 will be used to connect with DRDYn pin
i2c.setup(0, sda, scl, i2c.SLOW)  -- call i2c.setup() only once
HDC1000.setup(drdyn)
```

## HDC1000.config()
Function to configure various options of HDC1000 sensor.

#### Syntax
`HDC1000.config(address, resolution, heater)`

#### Parameters
- `address`: I²C sensor address. Default value is `0x40`.
- `resolution`: Temperature and humidity sensor resolution. Can be set to 14 bits for both temperature and humidity (`0x00`), 11 bits for temperature (`0x40`), 11 bits for humidity (`0x01`) or 8 bits for humidity (`0x20`). Default value is `0x00`.
- `heater`: Heater setting. `0x20` to enable and `0x00` to disable. Default value is `0x20`.

#### Returns
`nil`

## HDC1000.getTemp()
Reads the temperature from HDC1000 sensor.

#### Syntax
`HDC1000.getTemp()`

#### Parameters
None

#### Returns
Temperature in Celsius degrees.

## HDC1000.getHumi()
Reads the humidity value from HDC1000 sensor.

#### Syntax
`HDC1000.getHumi()`

#### Parameters
None

#### Returns
Humidity in percents.

## HDC1000.batteryDead()
Function that checks if voltage of sensor power supply is bellow or above 2.8V.

#### Syntax
`HDC1000.batteryDead()`

#### Parameters
None

#### Returns
`true` if battery voltage is bellow 2.8V, `false` otherwise.

#### Example
```lua
HDC1000 = require("HDC1000")

sda = 1
scl = 2
drdyn = false

i2c.setup(0, sda, scl, i2c.SLOW)  -- call i2c.setup() only once
HDC1000.setup(drdyn)
HDC1000.config() -- default values are used if called with no arguments. prototype is config(address, resolution, heater)

print(string.format("Temperature: %.2f °C\nHumidity: %.2f %%", HDC1000.getTemp(), HDC1000.getHumi()))

HDC1000 = nil
package.loaded["HDC1000"] = nil
```
