# bh1750 Module

##Require
```lua
bh1750 = require("bh1750")
```
## Release
```lua
bh1750 = nil
package.loaded["bh1750"]=nil
```
<a id="bh1750_init"></a>
##init()
####Description
Setting the I2C pin of bh1750.<br />

####Syntax
init(sda, scl)

####Parameters
sda: 1~12, IO index.<br />
scl: 1~12, IO index.<br />

####Returns
nil

####Example
```lua
SDA_PIN = 6 -- sda pin, GPIO12
SCL_PIN = 5 -- scl pin, GPIO14

bh1750 = require("bh1750")
bh1750.init(SDA_PIN, SCL_PIN)

-- release module
bh1750 = nil
package.loaded["bh1750"]=nil
```

####See also
**-**   []()

<a id="bh1750_read"></a>
##read()
####Description
Read Lux data from bh1750.<br />

####Syntax
read()

####Parameters
nil.<br />

####Returns
nil.<br />

####Example
```lua
SDA_PIN = 6 -- sda pin, GPIO12
SCL_PIN = 5 -- scl pin, GPIO14

bh1750 = require("bh1750")
bh1750.init(SDA_PIN, SCL_PIN)
bh1750.read()

-- release module
bh1750 = nil
package.loaded["bh1750"]=nil
```

####See also
**-**   []()

<a id="bh1750_getlux"></a>
##getlux()
####Description
Get lux from bh1750.<br />

####Syntax
getlux()

####Parameters
nil.<br />

####Returns
l: Integer, getlux from bh1750.

####Example
```lua
SDA_PIN = 6 -- sda pin, GPIO12
SCL_PIN = 5 -- scl pin, GPIO14

bh1750 = require("bh1750")
bh1750.init(SDA_PIN, SCL_PIN)
bh1750.read()
l = bh1750.getlux()
print("lux: "..(l / 100).."."..(l % 100).." lx")

-- release module
bh1750 = nil
package.loaded["bh1750"]=nil
```

####See also
**-**   []()
