# BMP085 module

##Require
```lua
bmp085 = require("bmp085")
```
## Release
```lua
bmp085 = nil
package.loaded["bmp085"]=nil
```
<a id="bmp085_init"></a>
##init()
####Description
Setting the i2c pin of bmp085.<br />

####Syntax
init(sda, scl)

####Parameters
sda: 1~12, IO index.<br />
scl: 1~12, IO index.<br />

####Returns
nil

####Example
```lua
bmp085 = require("bmp085")
gpio5 = 1
gpio4 = 2
sda = gpio5
scl = gpio4
bmp085.init(sda, scl)
-- Don't forget to release it after use
bmp085 = nil
package.loaded["bmp085"]=nil
```

####See also
**-**   []()

<a id="bmp085_getUP"></a>
##getUP()
####Description
Get calibrated data of pressure from bmp085.<br />

####Syntax
getUP(oss)

####Parameters
oss: Over sampling setting, which is 0,1,2,3. Default value is 0.<br />

####Returns
p: Integer, calibrated data of pressure from bmp085.

####Example
```lua
bmp085 = require("bmp085")
sda = 1
scl = 2
bmp085.init(sda, scl)
p = bmp085.getUP(oss)
print(p)
-- Don't forget to release it after use
bmp085 = nil
package.loaded["bmp085"]=nil
```

####See also
**-**   []()

<a id="bmp085_getUP_raw"></a>
##getUP_raw()
####Description
Get raw data of pressure from bmp085.<br />

####Syntax
getUP_raw(oss)

####Parameters
oss: Over sampling setting, which is 0,1,2,3. Default value is 0.<br />

####Returns
up_raw: Integer, raw data of pressure from bmp085.

####Example
```lua
bmp085 = require("bmp085")
sda = 1
scl = 2
bmp085.init(sda, scl)
up = bmp085.getUP_raw(oss)
print(up)
-- Don't forget to release it after use
bmp085 = nil
package.loaded["bmp085"]=nil
```

####See also
**-**   []()

<a id="bmp085_getUT"></a>
##getUT()
####Description
Get temperature from bmp085.<br />

####Syntax
getUT(num_10x)

####Parameters
num_10x: num_10x: bool value, if true, return number of 0.1 centi-degree. Default value is false, which return a string , eg: 16.7.<br />

####Returns
t: Integer or String, if num_10x is true, return number of 0.1 centi-degree, otherwise return a string.The temperature from bmp085.<br />

####Example
```lua
bmp085 = require("bmp085")
sda = 1
scl = 2
bmp085.init(sda, scl)
-- Get string of temperature.
p = bmp085.getUT(false)
print(p)
-- Get number of temperature.
p = bmp085.getUT(true)
print(p)
-- Don't forget to release it after use
bmp085 = nil
package.loaded["bmp085"]=nil
```

####See also
**-**   []()

<a id="bmp085_getAL"></a>
##getAL()
####Description
Get estimated data of altitude from bmp085.<br />

####Syntax
getAL(oss)

####Parameters
oss: over sampling setting, which is 0,1,2,3. Default value is 0.<br />

####Returns
e: Integer, estimated data of altitude. Altitudi can be calculated by pressure refer to sea level pressure, which is 101325. Pressure changes 100pa corresponds to 8.43m at sea level<br />

####Example
```lua
bmp085 = require("bmp085")
sda = 1
scl = 2
bmp085.init(sda, scl)
-- Get string of temperature.
e = bmp085.getAL()
print(p)
-- Don't forget to release it after use
bmp085 = nil
package.loaded["bmp085"]=nil
```

####See also
**-**   []()
