#DS3231 Module
##Require
```lua
ds3231 = require("ds3231")
```
## Release
```lua
ds3231 = nil
package.loaded["ds3231"]=nil
```
<a id="ds3231_init"></a>
##init()
####Description
Setting the pins of DS3231.

####Syntax
init(sda, scl)

####Parameters
sda: 1~10, IO index.  
scl: 1~10, IO index.

####Returns
nil

####Example
```lua
ds3231 = require("ds3231")
ds3231.init(3, 4)
-- Don't forget to release it after use
ds3231 = nil
package.loaded["ds3231"]=nil
```

####See also
**-**   []()


<a id="ds3231_settime"></a>
## setTime()
####Description
Sets the current date and time.

####Syntax
setTime(second, minute, hour, day, date, month, year)

####Parameters
second: 00-59  
minute: 00-59  
hour: 00-23  
day: 1-7 (Sunday = 1, Saturday = 7)  
date: 01-31  
month: 01-12  
year: 00-99

####Returns
nil

####Example
```lua
ds3231 = require("ds3231")
ds3231.init(3, 4)

-- Set date and time to Sunday, January 18th 2015 6:30PM
ds3231.setTime(0, 30, 18, 1, 18, 1, 15);

-- Don't forget to release it after use
ds3231 = nil
package.loaded["ds3231"]=nil
```

####See also
**-**   []()


<a id="ds3231_getTime"></a>
## getTime()
####Description
Get the current date and time.

####Syntax
getTime()

####Parameters
nil

####Returns
second: integer. Second 00-59  
minute: integer. Minute 00-59  
hour: integer. Hour 00-23  
day: integer. Day 1-7 (Sunday = 1, Saturday = 7)  
date: integer. Date 01-31  
month: integer. Month 01-12  
year: integer. Year 00-99  

####Example
```lua
ds3231=require("ds3231")
ds3231.init(3, 4)

-- Get date and time
second, minute, hour, day, date, month, year = ds3231.getTime();

-- Print date and time
print(string.format("Time & Date: %s:%s:%s %s/%s/%s", 
    hour, minute, second, date, month, year))

-- Don't forget to release it after use
ds3231 = nil
package.loaded["ds3231"]=nil

```
####See also
**-**   []()