# MCP23008 Module
| Since  | Origin / Contributor  | Maintainer  | Source  |
| :----- | :-------------------- | :---------- | :------ |
| 2015-03-02 | [AllAboutEE](https://github.com/AllAboutEE) | [AllAboutEE](https://github.com/AllAboutEE) | [mcp23008.lua](../../../lua_modules/mcp23008/mcp23008.lua) |

This Lua module provides access to [MCP23008](http://ww1.microchip.com/downloads/en/DeviceDoc/21919e.pdf) I²C I/O Expander.

!!! note
	This module requires `i2c` C module built into firmware.
	
### Require
```lua
mcp32008 = require("mcp32008")
```

### Release
```lua
mcp32008 = nil
package.loaded["mcp32008"] = nil
```

## mcp32008.begin()
Sets the MCP23008 device address's last three bits. 

!!! note
	The address is defined as binary `0100[A2][A1][A0]` where `A2`, `A1`, and `A0` are defined by the connection of the pins, e.g. if the pins are connected all to GND then the parameter address  will need to be `0x0`.

#### Syntax
`mcp23008.begin(address, pinSDA, pinSCL, speed)`

#### Parameters
- `address`: The 3 least significant bits (LSB) of the address
- `pinSDA`: The pin to use for SDA
- `pinSCL`: The pin to use for SCL
- `speed`: The speed of the I2C signal

#### Returns
`nil`

## mcp23008.writeGPIO()
Writes a byte of data to the GPIO register.

#### Syntax
`mcp23008.writeGPIO(dataByte)`

#### Parameters
- `dataByte`: The byte of data to write

#### Returns
`nil`

## mcp23008.readGPIO()
Reads a byte of data from the GPIO register

#### Syntax
`mcp23008.readGPIO()`

#### Parameters
None

#### Returns
One byte of data

## mcp23008.writeIODIR()
Writes one byte of data to the IODIR register.

#### Syntax
`mcp23008.writeIODIR(dataByte)`

#### Parameters
- `dataByte`: The byte of data to write

#### Returns
`nil`

## mcp23008.readIODIR()
Reads a byte from the IODIR register

#### Syntax
`mcp23008.readIODIR()`

#### Parameters
None

#### Returns
The byte of data in IODIR

## mcp23008.writeGPPU()
Writes a byte of data to the GPPU (Pull-UP resistors register)

#### Syntax
`mcp23008.writeIODIR(dataByte)`

#### Parameters
- `dataByte`: the value to write to the GPPU register. Each bit in this byte is assigned to an individual GPIO pin

#### Returns
`nil`

## mcp23008.readGPPU()
Reads the GPPU (Pull-UP resistors register) byte

#### Syntax
`mcp23008.readGPPU()`

#### Parameters
None

#### Returns
The GPPU byte i.e. state of all internal pull-up resistors

#### Notes
Other examples of using this module can be found in [mcp23008_buttons.lua](../../../lua_examples/mcp23008/mcp23008_buttons.lua) and  [mcp23008_leds.lua](../../../lua_examples/mcp23008/mcp23008_leds.lua) files.