# HDC1080 Module
| Since  | Origin / Contributor  | Maintainer  | Source  |
| :----- | :-------------------- | :---------- | :------ |
| 2017-04-01 | [Metin KOC](https://github.com/saucompeng) | [Metin KOC](https://github.com/saucompeng) | [hdc1080.c](../../../app/modules/hdc1080.c)|


This module provides access to the [HDC1080](http://www.ti.com/product/HDC1080) low power, high accuracy digital humidity sensor with temperature sensor.

## hdc1080.read()
Samples the sensor then returns temperature and humidity value.

#### Syntax
`hdc1080.read()`

#### Returns
Temperature data in centigrade and humidity data in percentage (0-100) (integer/float)

#### Example
```lua
local sda, scl = 1, 2
i2c.setup(0, sda, scl, i2c.SLOW)  -- call i2c.setup() only once
hdc1080.setup()
local temperature,humidity = hdc1080.read()
print(temperature)
print(humidity)
```

## hdc1080.setup()
Initializes the module.

#### Syntax
`hdc1080.setup()`

#### Parameters
- None

#### Returns
`nil`
