Adafruit provides a really nice [firmware flashing tutorial](https://learn.adafruit.com/building-and-running-micropython-on-the-esp8266/flash-firmware).  Below you'll find just the basics for the two popular tools esptool and NodeMCU Flasher.

!!! attention

    Keep in mind that the ESP8266 needs to be [put into flash mode](#putting-device-into-flash-mode) before you can flash a new firmware!

!!! important

    When switching between NodeMCU versions, see the notes about
    [Upgrading Firmware](#upgrading-firmware).

## Tool overview

**esptool.py**
> A cute Python utility to communicate with the ROM bootloader in Espressif ESP8266. It is intended to be a simple, platform independent, open source replacement for XTCOM.

Source: [https://github.com/themadinventor/esptool](https://github.com/themadinventor/esptool)

Supported platforms: OS X, Linux, Windows, anything that runs Python

**Running esptool.py**

Run the following command to flash an *aggregated* binary as is produced for example by the [cloud build service](build.md#cloud-build-service) or the [Docker image](build.md#docker-image).

`esptool.py --port <serial-port-of-ESP8266> write_flash -fm <mode> -fs <size> 0x00000 <nodemcu-firmware>.bin`

- `mode` is `qio` for 512&nbsp;kByte modules and `dio` for 4&nbsp;MByte modules (`qio` might work as well, YMMV).
- `size` is given in bits. Specify `4m` for 512&nbsp;kByte and `32m` for 4&nbsp;MByte.  If unsure, try a smaller size;
NodeMCU will by default detect and correct the size at first boot.

In some uncommon cases, the [SDK init data](#sdk-init-data) may be invalid and NodeMCU may fail to boot.  The easiest solution is to fully erase the chip before flashing:

`esptool.py --port <serial-port-of-ESP8266> erase_flash`

Check the [esptool flash modes documentation](https://github.com/themadinventor/esptool#flash-modes) for details and other options.

**NodeMCU Flasher**
> A firmware Flash tool for NodeMCU...We are working on next version and will use QT framework. It will be cross platform and open-source.

Source: [https://github.com/nodemcu/nodemcu-flasher](https://github.com/nodemcu/nodemcu-flasher)

Supported platforms: Windows

## Putting Device Into Flash Mode

To enable ESP8266 firmware flashing GPIO0 pin must be pulled low before the device is reset. Conversely, for a normal boot, GPIO0 must be pulled high or floating.

If you have a [NodeMCU dev kit](https://github.com/nodemcu/nodemcu-devkit-v1.0) then you don't need to do anything, as the USB connection can pull GPIO0 low by asserting DTR and reset your board by asserting RTS.

If you have an ESP-01 or other device without built-in USB, you will need to enable flashing yourself by pulling GPIO0 low or pressing a "flash" switch, while powering up or resetting the module.

## Which Files To Flash

If you build your firmware with the [cloud builder or the Docker image](build.md), or any other method that produces a *combined binary*, then you can flash that file directly to address 0x00000.

Otherwise, if you built your own firmware from source code:

- `bin/0x00000.bin` to 0x00000
- `bin/0x10000.bin` to 0x10000

## Upgrading Firmware

There are three potential issues that arise from upgrading (or downgrading!) firmware from one NodeMCU version to another:

* Lua scripts written for one NodeMCU version (like 0.9.x) may not work error-free on a more recent firmware.  Most notably, Espressif changed the `socket:send` operation to be asynchronous i.e. non-blocking. See [API documentation](modules/net.md#netsocketsend) for details.

* The NodeMCU flash filesystem may need to be reformatted, particularly if its address has changed because the new firmware has a much different size than the old firmware.  If it is not automatically formatted, then it should be valid and have the same contents as before the flash operation. You can still run [`file.format()`](modules/file.md#fileformat) to re-format your flash filesystem. You will know if you need to do this if your flash files exist but seem empty, or if data cannot be written to new files. However, this should be an exceptional case.

* The Espressif SDK Init Data may change between each NodeMCU firmware version, and may need to be erased or reflashed.  See [SDK Init Data](#sdk-init-data) for details.  Fully erasing the module before upgrading firmware will avoid this issue.

## SDK Init Data

!!! note

    Normally, NodeMCU will take care of writing the SDK init data when needed.  Most users can ignore this section.

NodeMCU versions are compiled against specific versions of the Espressif SDK.  The SDK reserves space in flash that is used to store calibration and other data.  This data changes between SDK versions, and if it is invalid or not present, the code may not boot correctly.  Symptoms include messages like `rf_cal[0] !=0x05,is 0xFF`, or endless reboot loops.

!!! tip

    If you are seeing these symptoms, ensure that your chip is fully erased before flashing, for example:

    `esptool.py --port <serial-port-of-ESP8266> erase_flash`

    Also verify that you are using an up-to-date NodeMCU release, as some early releases of NodeMCU 1.5.4.1 did not write the SDK init data to a freshly erased chip.

Espressif refers to this area as "System Param" and it resides in the last four 4&nbsp;kB sectors of flash.  Since SDK 1.5.4.1, a fifth sector is reserved for RF calibration (and its placement is controlled by NodeMCU), as described by this [patch notice](http://bbs.espressif.com/viewtopic.php?f=46&t=2407).  At minimum, Espressif states that the 4th sector from the end needs to be flashed with "init data", and the 2nd sector from the end should be blank.

The standard init data is provided as part of the SDK, in the file `esp_init_data_default.bin`.  NodeMCU will automatically flash this file to the right place on first boot, if the sector appears to be empty.  If you need to customize the contents of the init data, you can instead flash it manually and NodeMCU will not change it.  See "4.1 Non-FOTA Flash Map" and "6.3 RF Initialization Configuration" of the [ESP8266 Getting Started Guide](https://espressif.com/en/support/explore/get-started/esp8266/getting-started-guide) for details on init data addresses and customization.

