# APA102 Module
This module provides Lua access to [APA102 RGB LEDs](https://youtu.be/UYvC-hukz-0) which are similar in function to the common [WS2812](ws2812) addressable LEDs.

> DotStar LEDs are 5050-sized LEDs with an embedded micro controller inside the LED. You can set the color/brightness of each LED to 24-bit color (8 bits each red green and blue). Each LED acts like a shift register, reading incoming color data on the input pins, and then shifting the previous color data out on the output pin. By sending a long string of data, you can control an infinite number of LEDs, just tack on more or cut off unwanted LEDs at the end.

source: [Adafruit](https://www.adafruit.com/products/2343)

## apa102.write()
Send ABGR data in 8 bits to a APA102 chain.

#### Syntax
`apa102.write(data_pin, clock_pin, string)`

#### Parameters
- `data_pin` any GPIO pin 0, 1, 2, ...
- `clock_pin` any GPIO pin 0, 1, 2, ...
- `string` payload to be sent to one or more APA102 LEDs.
  It should be composed from a AGRB quadruplet per element.
    - `A1` the first pixel's Intensity channel (0-31)
    - `B1` the first pixel's Blue channel (0-255)<br />
    - `G1` the first pixel's Green channel (0-255)
    - `R1` the first pixel's Red channel (0-255)
    ... You can connect a lot of APA102 ...
    - `A2`, `G2`, `R2`, `B2` are the next APA102s Intensity, Blue, Green and channel parameters

#### Returns
`nil`

#### Example
```lua
a = 31
g = 0
r = 255
b = 0
led_abgr = string.char(a, g, r, b, a, g, r, b) 
apa102.write(2, 3, leds_abgr) -- turn two APA102s to red, connected to data_pin 2 and clock_pin 3
```
