# WS2812 Module
| Since  | Origin / Contributor  | Maintainer  | Source  |
| :----- | :-------------------- | :---------- | :------ |
| 2015-02-05 | [Till Klocke](https://github.com/dereulenspiegel) | [Till Klocke](https://github.com/dereulenspiegel) | [ws2812.c](../../../app/modules/ws2812.c)|


## ws2812.write()
Send GRB data in 8 bits to a WS2812 chain.

#### Syntax
`ws2812.writegrb(pin, string)`

#### Parameters
- `pin` is ignored. Only works with GPIO2.
- `string` payload to be sent to one or more WS2812 LEDs.
  It should be composed from a GRB triplet per element.
    - `G1` the first pixel's Green channel (0-255)
    - `R1` the first pixel's Red channel (0-255)
    - `B1` the first pixel's Blue channel (0-255)<br />
    ... You can connect a lot of WS2812 ...
    - `G2`, `R2`, `B2` are the next WS2812's Green, Red, and Blue channel parameters

#### Returns
`nil`

```lua
g = 0
r = 255
b = 0
leds_grb = string.char(g,r,b, g,r,b) 
ws2812.write(2, leds_grb) -- turn two WS2812Bs to red, connected to pin GPIO2
```

## ws2812.writergb()
Send GRB data in 8bits to a WS2812 chain.

#### Syntax
`ws2812.writergb(pin, string)`

#### Parameters
- `pin` is ignored. Only works with GPIO2.
- `string` payload to be sent to one or more WS2812 LEDs.
  It should be composed from an RGB triplet per element.
    - `R1` the first pixel's Red channel (0-255)
    - `G1` the first pixel's Green channel (0-255)
    - `B1` the first pixel's Blue channel (0-255)<br />
    ... You can connect a lot of WS2812 ...
    - `R2`, `G2`, `B2` are the next WS2812's Red, Green, and Blue channel parameters

#### Returns
`nil`

#### Example
```lua
leds_rgb = string.char(255,0,0, 0,255,0, 0,0,255) 
ws2812.writergb(2, leds_rgb) -- turn three WS2812Bs to red, green, and blue respectively
```
