# TCS34725 module
| Since  | Origin / Contributor  | Maintainer  | Source  |
| :----- | :-------------------- | :---------- | :------ |
| 2017-04-02 | [tjhowse](https://github.com/tjhowse) | [tjhowse](https://github.com/tjhowse) | [tcs34725.c](../../../app/modules/tcs34725.c)|

This module provides a simple interface to [TCS34725 colour/light sensors](https://www.adafruit.com/product/1334) (Adafruit).

!!! Warning

	You must call [`setup()`](#tcs34725setup) before you can start reading values!

## tcs34725.setup()

Initialization via this call is mandatory before values can be read.

#### Syntax

`tcs34725.setup()`

#### Returns
`0` if setup has failed (no sensor connected?), `1` if sensor is TCS34725

#### Example
```lua
tcs34725.setup()
tcs34725.enable(function()
	print("TCS34275 Enabled")
	clear,red,green,blue=tcs34725.raw()
end)
```

## tcs34725.enable(function())

Enables the sensor. Can be used to wake up after a disable.

#### Syntax
```lua
tcs34725.enable(function()
	print("TCS34275 Enabled")
	clear,red,green,blue=tcs34725.raw()
end)
```
#### Parameters
A function called when the sensor has finished initialising.

#### Returns  
0

## tcs34725.disable()

Disables the sensor. Enables a low-power sleep mode.

#### Syntax
`tcs34725.disable()`

#### Returns  
0

## tcs34725.raw()

Reads the clear, red, green and blue values from the sensor.

#### Syntax
`clear,red,green,blue=tcs34725.raw()`

#### Returns  
clear, red, green, blue in uint16_t.

## tcs34725.setGain()

Sets the gain of the sensor. Must be called after the sensor is enabled.

#### Syntax
`tcs34725.setGain(gain)`

#### Parameters
|gain|Gain|
|-----|-----------------|
|0x00|TCS34725_GAIN_1X|
|0x01|TCS34725_GAIN_4X|
|0x02|TCS34725_GAIN_16X|
|0x03|TCS34725_GAIN_60X|

#### Returns  
0

## tcs34725.setIntegrationTime()

Sets the integration time of the sensor. Must be called after the sensor is enabled.

#### Syntax
`tcs34725.setIntegrationTime(time)`

#### Parameters
|time|Gain|
|-----|-----------------|
|0xFF|TCS34725_INTEGRATIONTIME_2_4MS|
|0xF6|TCS34725_INTEGRATIONTIME_24MS|
|0xD5|TCS34725_INTEGRATIONTIME_101MS|
|0xC0|TCS34725_INTEGRATIONTIME_154MS|
|0x00|TCS34725_INTEGRATIONTIME_700MS|
	
#### Returns  
0
