# BH1750 Module
| Since  | Origin / Contributor  | Maintainer  | Source  |
| :----- | :-------------------- | :---------- | :------ |
| 2015-01-30 | [Martin Han](https://github.com/MarsTechHAN) | [Martin Han](https://github.com/MarsTechHAN) | [bh1750.lua](../../lua_modules/bh1750/bh1750.lua) |

This Lua module provides access to [BH1750](https://www.mouser.com/ds/2/348/bh1750fvi-e-186247.pdf) I²C ambient light sensor.

!!! note
	This module requires `i2c` C module built into firmware.

### Require
```lua
bh1750 = require("bh1750")
```

### Release
```lua
bh1750 = nil
package.loaded["bh1750"] = nil
```

## bh1750.init()
Initializes the module and sets up I²C with hardcoded device address.

#### Syntax
`bh1750.init(sda, scl)`

#### Parameters
- `sda` SDA pin number.
- `scl` SCL pin number.

#### Returns
`nil`

## bh1750.read()
Reads lux value from the sensor.

#### Syntax
`bh1750.read()`

#### Parameters
None

#### Returns
Lux value.

## bh1750.getlux()
Function used to return last read lux value.

#### Syntax
`bh1750.getlux()`

#### Parameters
None

#### Returns
Last known lux value.

#### Example
```lua
SDA_PIN = 6 -- sda pin, GPIO12
SCL_PIN = 5 -- scl pin, GPIO14

bh1750 = require("bh1750")
bh1750.init(SDA_PIN, SCL_PIN)
bh1750.read()
l = bh1750.getlux()
print("lux: "..(l / 100).."."..(l % 100).." lx")

-- release module
bh1750 = nil
package.loaded["bh1750"] = nil
```
