# si7021 module

##Require
```lua
si7021 = require("si7021")
```
## Release
```lua
si7021 = nil
package.loaded["si7021"]=nil
```
<a id="si7021_init"></a>
##init()
####Description
Setting the i2c pin of si7021.<br />

####Syntax
init(sda, scl)

####Parameters
sda: 1~12, IO index.<br />
scl: 1~12, IO index.<br />

####Returns
nil

####Example
```lua
si7021 = require("si7021")
gpio5 = 1
gpio4 = 2
sda = gpio5
scl = gpio4
si7021.init(sda, scl)
-- Don't forget to release it after use
si7021 = nil
package.loaded["si7021"]=nil
```

####See also
**-**   []()

<a id="si7021_read"></a>
##read()
####Description
Read temperature and humidity from si7021.<br />

####Syntax
read()

####Parameters
nil.<br />

####Returns
nil(Why?).<br />

####Example
```lua
si7021 = require("si7021")
sda = 1
scl = 2
si7021.init(sda, scl)
r = si7021.read()
print(r)
-- Don't forget to release it after use
si7021 = nil
package.loaded["si7021"]=nil
```

####See also
**-**   []()

<a id="si7021_getHumidity"></a>
##getHumidity()
####Description
Get humidity from si7021.<br />

####Syntax
getHumidity()

####Parameters
nil.<br />

####Returns
h: Integer, humidity from si7021.

####Example
```lua
si7021 = require("si7021")
sda = 1
scl = 2
si7021.init(sda, scl)
h = si7021.getHumidity()
print(h)
-- Don't forget to release it after use
si7021 = nil
package.loaded["si7021"]=nil
```

####See also
**-**   []()

<a id="si7021_getTemperature"></a>
##getTemperature()
####Description
Get temperature from si7021.<br />

####Syntax
getTemperature()

####Parameters
nil.<br />

####Returns
t: Integer, temperature from si7021.

####Example
```lua
si7021 = require("si7021")
sda = 1
scl = 2
si7021.init(sda, scl)
t = si7021.getTemperature()
print(t)
-- Don't forget to release it after use
si7021 = nil
package.loaded["si7021"]=nil
```

####See also
**-**   []()
