#DS18B20 模块
##引用
```lua
ds18b20 = require("ds18b20")
```
#释放
```lua
ds18b20 = nil
package.loaded["ds18b20"]=nil
```
##常量
C, F, K

<a id="ds18b20_setup"></a>
##setup()
####描述
设置DS18B20所在的管脚(pin)。<br />

####语法
setup(pin)

####参数
pin: 1~10, IO 编号。如果参数为nil，会自动设定为9(GPIO2).<br />

####返回值
nil

####示例
```lua
ds18b20 = require("ds18b20")
ds18b20.setup(9)
-- Don't forget to release it after use
ds18b20 = nil
package.loaded["ds18b20"]=nil

```

####参见
**-**   []()


<a id="ds18b20_addrs"></a>
## addrs()
####描述
返回单总线上所有DS18B20器件的地址列表(table)。如果没有执行过setup(pin)，则会自动对引脚9(GPIO2)进行单总线模式初始化。<br />

####语法
addrs()

####参数
nil
####返回值
addrs: 返回包含单总线上所有DS18B20器件的地址列表(table)。其中地址是字符串类型(String)。如果失败则返回nil. <br />

####示例
```lua
ds18b20 = require("ds18b20")
ds18b20.setup(9)
addrs = ds18b20.addrs()
if (addrs ~= nil) then
  print("Total DS18B20 sensors: "..table.getn(addrs))
end
-- Don't forget to release it after use
ds18b20 = nil
package.loaded["ds18b20"]=nil

```

####参见
**-**   []()


<a id="ds18b20_readNumber"></a>
## readNumber()
####描述
读取温度数值。如果没有执行过setup(pin)，则会自动对引脚9(GPIO2)进行单总线模式初始化。  <br />

####语法
readNumber(addr, unit)

####参数
addr: 字符串, DS18B20地址。 如果该参数为nil，会自动选择第一个发现的地址。<br />
unit: 单位转换，只接受常量C(摄氏度)，F(华氏度)， K(开氏度)。如果该参数为nil，会自动选择常量C(摄氏度) 。<br />

####返回值
t1: 数值，温度的整数部分。如果读取失败返回nil.<br />
t2: 数值，温度的小数部分。如果读取失败返回nil.<br />

####示例
```lua
t=require("ds18b20")
t.setup(9)
addrs=t.addrs()
-- Total DS18B20 numbers, assume it is 2
print(table.getn(addrs))
-- The first DS18B20
print(t.readNumber(addrs[1],t.C))
print(t.readNumber(addrs[1],t.F))
print(t.readNumber(addrs[1],t.K))
-- The second DS18B20
print(t.readNumber(addrs[2],t.C))
print(t.readNumber(addrs[2],t.F))
print(t.readNumber(addrs[2],t.K))
-- Just read
print(t.readNumber())
-- Just read as fahrenheit
print(t.readNumber(nil,t.F))
-- Read as values
t1, t2 = t.readNumber()
-- Don't forget to release it after use
t = nil
ds18b20 = nil
package.loaded["ds18b20"]=nil

```
####参见
**-**   []()

<a id="ds18b20_read"></a>
## read()
####描述
读取温度字符串。如果没有执行过setup(pin)，则会自动对引脚9(GPIO2)进行单总线模式初始化。  <br />

####语法
read(addr, unit)

####参数
addr: 字符串, DS18B20地址。 如果该参数为nil，会自动选择第一个发现的地址。<br />
unit: 单位转换，只接受常量C(摄氏度)，F(华氏度)， K(开氏度)。如果该参数为nil，会自动选择常量C(摄氏度) 。<br />

####返回值
t: 字符串，表示成字符串形式的温度。如果读取失败返回nil.<br />

####示例
```lua
t=require("ds18b20")
t.setup(9)
addrs=t.addrs()
-- Total DS18B20 numbers, assume it is 2
print(table.getn(addrs))
-- The first DS18B20
print(t.read(addrs[1],t.C))
print(t.read(addrs[1],t.F))
print(t.read(addrs[1],t.K))
-- The second DS18B20
print(t.read(addrs[2],t.C))
print(t.read(addrs[2],t.F))
print(t.read(addrs[2],t.K))
-- Just read
print(t.read())
-- Just read as centigrade
print(t.read(nil,t.C))
-- Don't forget to release it after use
t = nil
ds18b20 = nil
package.loaded["ds18b20"]=nil
```
####参见
**-**   []()

