# LM92 Module
| Since  | Origin / Contributor  | Maintainer  | Source  |
| :----- | :-------------------- | :---------- | :------ |
| 2015-05-17 | [Levente Tamas](https://github.com/elgarbe) | [Levente Tamas](https://github.com/elgarbe) | [lm92.lua](../../lua_modules/lm92/lm92.lua) |

This Lua module provides access to [LM92](http://www.ti.com/lit/ds/symlink/lm92.pdf) I²C ±0.33C 12bit+sign temperature sensor.

!!! note
	This module requires `i2c` C module built into firmware.
	
### Require
```lua
lm92 = require("lm92")
```

### Release
```lua
lm92 = nil
package.loaded["lm92"] = nil
```

## lm92.setup()
Function used to setup the address for lm92.

#### Syntax
`lm92.setup(address)`

#### Parameters
- `address`: I²C address used by LM92. Depends on the connection of `A0` and `A1` pins. Can be either `0x48`, `0x49`, `0x4a` or `0x4b` according to page 9 of [LM92 datasheet](http://www.ti.com/lit/ds/symlink/lm92.pdf)

#### Returns
`nil`

#### Example
```lua
lm92 = require("lm92")
sda = 3 -- GPIO 0
scl = 4 -- GPIO 2
addr = 0x48
i2c.setup(0, sda, scl, i2c.SLOW)  -- call i2c.setup() only once
lm92.setup(addr)
```

## lm92.getTemperature()
Returns the temperature register's content.

#### Syntax
`lm92.getTemperature()`

#### Parameters
None

#### Returns
Temperature in degree Celsius.

## lm92.shutdown()
Makes the chip enter the low power shutdown mode.

#### Syntax
`lm92.shutdown()`

#### Parameters
None

#### Returns
`nil`

## lm92.wakeup()
Makes the chip exit the low power shutdown mode.

#### Syntax
`lm92.wakeup()`

#### Parameters
None

#### Returns
`nil`

## lm92.setThyst()

Set hysteresis Temperature.

#### Syntax
`lm92.setThyst(htemp)`

#### Parameters
- `htemp`: Hysteresis temperature from 130 to -55 in ºC

#### Returns
`nil`

## lm92.setTcrit()
Set Critical Temperature.

#### Syntax
`lm92.setTcrit(ctemp)`

#### Parameters
`ctemp`: Critical temperature from 130 to -55 in ºC

#### Returns
`nil`

## lm92.setTlow()
Set Low Window Temperature.

#### Syntax
`lm92.setTlow(lwtemp)`

####Parameters
- `lwtemp`:  Low window temperature from 130 to -55 in ºC

#### Returns
`nil`

## lm92.setThigh()
Set High Window Temperature.

#### Syntax
`lm92.setThigh(hwtemp)`

#### Parameters
- `hwtemp`: High window temperature from 130 to -55 in ºC

#### Returns
`nil`

## lm92.getThyst()
Get hysteresis Temperature.

#### Syntax
`lm92.getThyst()`

#### Parameters
None

#### Returns
Hysteresis Temperature in degree Celsius.

## lm92.getTcrit()
Get Critical Temperature.

#### Syntax
`lm92.getTcrit()`

#### Parameters
None

#### Returns
Critical Temperature in degree Celsius.

## lm92.getTlow()
Get Low Window Temperature.

#### Syntax
`lm92.getTlow()`

#### Parameters
None

#### Returns
Low Window Temperature in degree Celsius.

## lm92.getThigh()
Get High Window Temperature.

#### Syntax
`lm92.getThigh()`

#### Parameters
None

#### Returns
High Window Temperature in degree Celsius.

#### Example
```lua
--node.compile("lm92.lua")
lm92 = require("lm92")
sda = 3 -- GPIO 0
scl = 4 -- GPIO 2
addr = 0x48
i2c.setup(0, sda, scl, i2c.SLOW)  -- call i2c.setup() only once
lm92.setup(addr)
 
t = lm92.getTemperature()
print("Got temperature: "..t.." C")

--Seting comparison temperatures
lm92.setThyst(3)
lm92.setTcrit(40.75)
lm92.setTlow(28.5)
lm92.setThigh(31.625)

t = lm92.getThyst()
print("Got hyster: "..t.." C")
t = lm92.getTcrit()
print("Got Crit: "..t.." C")
t = lm92.getTlow()
print("Got Low: "..t.." C")
t = lm92.getThigh()
print("Got High: "..t.." C")
```

#### TODO:
- add full support of the features, including interrupt and critical alert support
