# HMC5883L Module
| Since  | Origin / Contributor  | Maintainer  | Source  |
| :----- | :-------------------- | :---------- | :------ |
| 2016-04-09 | [Jason Schmidlapp](https://github.com/jschmidlapp) | [Jason Schmidlapp](https://github.com/jschmidlapp) | [hmc5883l.c](../../../app/modules/hmc5883l.c)|


This module provides access to the [HMC5883L](https://www.sparkfun.com/products/10530) three axis digital compass.

## hmc5883l.read()
Samples the sensor and returns X,Y and Z data.

#### Syntax
`hmc5883l.read()`

#### Returns
x,y,z measurements (integers)
temperature multiplied with 10 (integer)

#### Example
```lua
local sda, scl = 1, 2
i2c.setup(0, sda, scl, i2c.SLOW) -- call i2c.setup() only once
hmc5883l.setup()
local x,y,z = hmc5883l.read()
print(string.format("x = %d, y = %d, z = %d", x, y, z))
```

## hmc5883l.setup()
Initializes the module.

#### Syntax
`hmc5883l.setup()`

#### Parameters
None

#### Returns
`nil`
