# u8g2 Module
| Since  | Origin / Contributor  | Maintainer  | Source  |
| :----- | :-------------------- | :---------- | :------ |
| 2017-06-02 | [Oli Kraus](https://github.com/olikraus/u8glib), [Arnim Läuger](https://github.com/devsaurus) | [Arnim Läuger](https://github.com/devsaurus) | [u8g2.c](../../../components/u8g2.c)|

U8g2 is a graphics library developed at [olikraus/u8g2](https://github.com/olikraus/u8g2) with support for many different displays. It is the successor of [U8glib](https://github.com/olikraus/u8glib) which is not developed any further.

The NodeMCU firmware supports the following displays in I²C and SPI mode:

- ld7032 60x32
- sh1106 128x64
- ssd1305 128x32
- ssd1306 - 128x32, 128x64, and 64x48 variants
- ssd1309 128x64
- ssd1325 128x63
- ssd1327 96x96
- st7588 jlx12864
- uc1604 jlx19264
- uc1608 - 240x180 and erc24064 variants
- ux1610 dogxl160
- uc1611 - dogm240 and dogxl240 variants

SPI only:

- ist3020 erc19264
- ls013b7dh03 128x128
- pcd8544 84x48
- pcf8812 96x65
- ssd1322 nhd 256x64
- ssd1329 128x96
- ssd1606 172x72
- ssd1607 200x200
- st7565 - variants dogm128/132, erc12864, lm6059, c12832/c12864, and zolen 128x64
- st7567 132x64
- uc1601_c128032
- uc1604 jlx19264
- uc1701 - dogs102 and mini12864 variants

This integration is based on [v2.15.2](https://github.com/olikraus/U8g2_Arduino/releases/tag/2.15.2).

## Overview
### I²C Connection
Hook up SDA and SCL to any free GPIOs. Eg. [graphics_test.lua](../../../lua_examples/u8glib/u8g_graphics_test.lua) expects SDA=GPIO16 and SCL=GPIO17. They are used to set up nodemcu's I²C driver before accessing the display:
```lua
id  = i2c.HW0
sda = 16
scl = 17
i2c.setup(id, sda, scl, i2c.FAST)
```
### SPI connection
Hook up pins to any free GPIOs:

- SCLK
- MOSI
- CS
- D/C
- RES (optional for some displays)

Again, refer to the initialization sequence eg. in [graphics_test.lua](../../../lua_examples/u8glib/u8g_graphics_test.lua):
```lua
sclk = 19
mosi = 23
bus = spi.master(spi.HSPI, {sclk=sclk, mosi=mosi})
```

### Library Usage
The Lua bindings for this library closely follow u8g2's object oriented C++ API. Based on the u8g2 class, you create an object for your display type.

SSD1306 via I²C:
```lua
sla = 0x3c
disp = u8g2.ssd1306_i2c_128x64_noname(id, sla)
```

SSD1306 via SPI:
```lua
cs  = 22
dc  = 16
res = 0 -- RES is optional YMMV
disp = u8g2.ssd1306_128x64_noname(bus, cs, dc, res)
```

This object provides all of u8g2's methods to control the display. Refer to [graphics_test.lua](../../../lua_examples/u8glib/u8g_graphics_test.lua) to get an impression how this is achieved with Lua code. Visit the [u8g2 homepage](https://github.com/olikraus/u8g2) for technical details.


### Displays
I²C and HW SPI based displays with support in u8g2 can be enabled. To get access to the respective constructors, enable the desired entries for I²C and SPI displays in u8g2's sub-menu (run `make menuconfig`).

### Fonts
u8g2 comes with a wide range of fonts for small displays. They can be supplied as strings or compiled into the firmware image to decrease the RAM footprint. Simply add the desired fonts to the font selection sub-entry via `make menuconfig`.

They'll become available as `u8g2.<font_name>` in Lua.

### Bitmaps
XBM bitmaps are supplied as strings to `drawXBM()`. This off-loads all data handling from the u8g2 module to generic methods for binary files. See [graphics_test.lua](../../../lua_examples/u8glib/u8g_graphics_test.lua).

In contrast to the source code based inclusion of XBMs in upstream u8g2 library, it's required to provide precompiled binary files. This can be performed online with [Online-Utility's Image Converter](http://www.online-utility.org/image_converter.jsp): Convert from XBM to MONO format and upload the binary result.

## I²C Display Drivers
Initialize a display via I²C.

- `u8g2.ld7032_i2c_60x32()`
- `u8g2.sh1106_i2c_128x64_noname()`
- `u8g2.sh1106_i2c_128x64_vcomh0()`
- `u8g2.ssd1305_i2c_128x32_noname()`
- `u8g2.ssd1306_i2c_64x48_er()`
- `u8g2.ssd1306_i2c_128x32_univision()`
- `u8g2.ssd1306_i2c_128x64_noname()`
- `u8g2.ssd1306_i2c_128x64_vcomh0()`
- `u8g2.ssd1309_i2c_128x64_noname0()`
- `u8g2.ssd1309_i2c_128x64_noname2()`
- `u8g2.ssd1325_i2c_nhd_128x64()`
- `u8g2.ssd1327_i2c_seeed_96x96()`
- `u8g2.st7588_i2c_jlx12864()`
- `u8g2.uc1604_i2c_jlx19264()`
- `u8g2.uc1608_i2c_erc24064()`
- `u8g2.uc1608_i2c_240x128()`
- `u8g2.uc1610_i2c_ea_dogxl160()`
- `u8g2.uc1611_i2c_ea_dogm240()`
- `u8g2.uc1611_i2c_ea_dogxl240()`

#### Syntax
`u8g2.ssd1306_i2c_128x64_noname(id, address)`

#### Parameters
- `id` i2c interface id, see [i2c module](i2c.md)
- `address` I²C slave address of display (unshifted)

#### Returns
u8g2 display object

#### Example
```lua
id  = i2c.HW0
sda = 16
scl = 17
sla = 0x3c
i2c.setup(id, sda, scl, i2c.FAST)
disp = u8g2.ssd1306_i2c_128x64_noname(id, sla)
```

## SPI Display Drivers
Initialize a display via Hardware SPI.

- `u8g2.ist3020_erc19264()`
- `u8g2.ld7032_60x32()`
- `u8g2.ls013b7dh03_128x128()`
- `u8g2.nt7534_tg12864r()`
- `u8g2.pcd8544_84x48()`
- `u8g2.pcf8812_96x65()`
- `u8g2.sh1106_128x64_noname()`
- `u8g2.sh1106_128x64_vcomh0()`
- `u8g2.ssd1305_128x32_noname()`
- `u8g2.ssd1306_128x32_univision()`
- `u8g2.ssd1306_128x64_noname()`
- `u8g2.ssd1306_128x64_vcomh0()`
- `u8g2.ssd1306_64x48_er()`
- `u8g2.ssd1309_128x64_noname0()`
- `u8g2.ssd1309_128x64_noname2()`
- `u8g2.ssd1322_nhd_256x64()`
- `u8g2.ssd1325_nhd_128x64()`
- `u8g2.ssd1327_seeed_96x96()`
- `u8g2.ssd1329_128x96_noname()`
- `u8g2.ssd1606_172x72()`
- `u8g2.ssd1607_200x200()`
- `u8g2.st7565_ea_dogm128()`
- `u8g2.st7565_ea_dogm132()`
- `u8g2.st7565_erc12864()`
- `u8g2.st7565_lm6059()`
- `u8g2.st7565_nhd_c12832()`
- `u8g2.st7565_nhd_c12864()`
- `u8g2.st7565_zolen_128x64()`
- `u8g2.st7567_pi_132x64()`
- `u8g2.st7588_jlx12864()`
- `u8g2.st7920_s_128x64()`
- `u8g2.st7920_s_192x32()`
- `u8g2.uc1604_jlx19264()`
- `u8g2.uc1608_240x128()`
- `u8g2.uc1608_erc24064()`
- `u8g2.uc1610_ea_dogxl160()`
- `u8g2.uc1611_ea_dogm240()`
- `u8g2.uc1611_ea_dogxl240()`
- `u8g2.uc1701_ea_dogs102()`
- `u8g2.uc1701_mini12864()`

#### Syntax
`u8g2.ssd1306_128x64_noname(cs, dc[, res])`

#### Parameters
- `cs` GPIO pin for CS
- `dc` GPIO pin for DC
- `res` GPIO pin for RES, none if omitted

#### Returns
u8g2 display object

#### Example
```lua
sclk = 19
mosi = 23
cs   = 22
dc   = 16
res  = 17
bus = spi.master(spi.HSPI, {sclk=sclk, mosi=mosi})
disp = u8g2.ssd1306_128x64_noname(bus, cs, dc, res)
```

## Constants
Constants for various functions.

`u8g2.DRAW_UPPER_RIGHT`, `u8g2.DRAW_UPPER_LEFT`, `u8g2.DRAW_LOWER_RIGHT`, `u8g2.DRAW_LOWER_LEFT`, `u8g2.DRAW_ALL`,

`u8g2.R0`, `u8g2.R1`, `u8g2.R2`, `u8g2.R3`, `u8g2.MIRROR`,

`u8g2.font_6x10`, ...
