#DS18B20 Module
##Require
```lua
ds18b20 = require("ds18b20")
```
## Release
```lua
ds18b20 = nil
package.loaded["ds18b20"]=nil
```
##Constant
C, F, K

<a id="ds18b20_setup"></a>
##setup()
####Description
Setting the pin of DS18B20.<br />

####Syntax
setup(pin)

####Parameters
pin: 1~10, IO index. If parameter is nil, it will use pin 9(GPIO2) automatically.<br />

####Returns
nil

####Example
```lua
ds18b20 = require("ds18b20")
ds18b20.setup(9)
-- Don't forget to release it after use
ds18b20 = nil
package.loaded["ds18b20"]=nil
```

####See also
**-**   []()


<a id="ds18b20_addrs"></a>
## addrs()
####Description
Return a table contain all of the addresses of DS18B20 on one-wire. If the setup(pin) function not executed, the pin 9(GPIO2) will be initialized as one-wire mode automatically. <br />

####Syntax
addrs()

####Parameters
nil
####Returns
addrs: A table contain all of the addresses of DS18B20 on one-wire. Every address is a string. If failed, it will be nil. <br />

####Example
```lua
ds18b20 = require("ds18b20")
ds18b20.setup(9)
addrs = ds18b20.addrs()
if (addrs ~= nil) then
  print("Total DS18B20 sensors: "..table.getn(addrs))
end
-- Don't forget to release it after use
ds18b20 = nil
package.loaded["ds18b20"]=nil
```

####See also
**-**   []()


<a id="ds18b20_readNumber"></a>
## readNumber()
####Description
Read the value of temperature.  If the setup(pin) function not executed, the pin 9(GPIO2) will be initialized as one-wire mode automatically.  <br />

####Syntax
readNumber(addr, unit)

####Parameters
addr: string, the address of DS18B20. It will select the first address which be found when this parameter is nil.<br />
unit: integer, unit conversion. Only Constant is acceptable, such as C(Celsius),F(Fahrenheit) and K(Kelvin). If this parameter is nil, the constant C(Celsius) will be selected automatically. <br />

####Returns
t1: integer. The integer part of the temperature. If it read fails, return nil. <br />
t2: integer. The fractional part of the temperature. If it read fails, return nil. <br />

####Example
```lua
t=require("ds18b20")
t.setup(9)
addrs=t.addrs()
-- Total DS18B20 numbers, assume it is 2
print(table.getn(addrs))
-- The first DS18B20
print(t.readNumber(addrs[1],t.C))
print(t.readNumber(addrs[1],t.F))
print(t.readNumber(addrs[1],t.K))
-- The second DS18B20
print(t.readNumber(addrs[2],t.C))
print(t.readNumber(addrs[2],t.F))
print(t.readNumber(addrs[2],t.K))
-- Just read
print(t.readNumber())
-- Just read as fahrenheit
print(t.readNumber(nil,t.F))
-- Read as values
t1, t2 = t.readNumber()
-- Don't forget to release it after use
t = nil
ds18b20 = nil
package.loaded["ds18b20"]=nil
```
####See also
**-**   []()

<a id="ds18b20_read"></a>
## read()
####Description
Read the string of temperature.  If the setup(pin) function not executed, the pin 9(GPIO2) will be initialized as one-wire mode automatically.  <br />

####Syntax
read(addr, unit)

####Parameters
addr: string, the address of DS18B20. It will select the first address which be found when this parameter is nil.<br />
unit: integer, unit conversion. Only Constant is acceptable, such as C(Celsius),F(Fahrenheit) and K(Kelvin). If this parameter is nil, the constant C(Celsius) will be selected automatically. <br />

####Returns
t: string. The string of the temperature. If it read fails, return nil.<br />

####Example
```lua
t=require("ds18b20")
t.setup(9)
addrs=t.addrs()
-- Total DS18B20 numbers, assume it is 2
print(table.getn(addrs))
-- The first DS18B20
print(t.read(addrs[1],t.C))
print(t.read(addrs[1],t.F))
print(t.read(addrs[1],t.K))
-- The second DS18B20
print(t.read(addrs[2],t.C))
print(t.read(addrs[2],t.F))
print(t.read(addrs[2],t.K))
-- Just read
print(t.read())
-- Just read as centigrade
print(t.read(nil,t.C))
-- Don't forget to release it after use
t = nil
ds18b20 = nil
package.loaded["ds18b20"]=nil
```
####See also
**-**   []()

